/******************************************************************************

  Copyright (C) 2010 [Hilscher Gesellschaft für Systemautomation mbH]

  This program can be used by everyone according to the netX Open Source
  Software license. The license agreement can be downloaded from
  http://www.industrialNETworX.com

 ******************************************************************************

  Last Modification:
    @version $Id: ProfibusMPI_Functionlist.h 13178 2010-12-13 07:56:51Z AndreasB $

  Description:
    The header has to be included in the configuration source file of firmware.
    Use the content of header file to configure the startup parameter of tasks
    and to define the entry point <code>TaskEnter_ProfibusMPI_AP</code>
    of task.

  Changes:
    Date        Author        Description
  ---------------------------------------------------------------------------
    2010-10-20  NC            File created.

******************************************************************************/
#ifndef __PROFIBUS_MPI_FUNCTIONLIST_H
#define __PROFIBUS_MPI_FUNCTIONLIST_H

#include "TLR_INX_Includes.h"

/******************************************************************************
  Version of task startup parameter
    compiler error because of new name of define (e.g. _1 --> _2), check
    startup parameters for changes/extensions!
******************************************************************************/
#define PROFIBUS_MPI_STARTUP_PARAM_VERSION_3 (3)

#define PROFIBUS_MPI_STARTUP_BEHAVIOR_STARTSTOP_MASK    0x00000001
#define PROFIBUS_MPI_STARTUP_BEHAVIOR_STARTSTOP_START   0x00000000
#define PROFIBUS_MPI_STARTUP_BEHAVIOR_STARTSTOP_STOP    0x00000001

/******************************************************************************
  Startup Parameter
   The structure represent a set of the startup parameter, which can be defined
    or have to be defined to configure the task.
******************************************************************************/
typedef struct PROFIBUS_MPI_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_UINT32  ulTaskIdentifier;
  TLR_UINT32  ulParamVersion;

  TLR_STR     *pszProfibusDlQueueName;
  TLR_UINT32  ulProfibusDlTaskInstance;
  TLR_UINT32  ulXC;
  TLR_UINT32  ulStartupBehavior;

}PROFIBUS_MPI_STARTUPPARAMETER_T;

/******************************************************************************
   The following prototypes are declared to represent
      - the entry point of task
      - the exit point of task to delete only the task resources (exit)
******************************************************************************/
TLR_RESULT TaskExit_ProfibusMPI( TLR_VOID *pvRsc);
TLR_VOID TaskEnter_ProfibusMPI ( TLR_VOID *pvInit);


#endif /* __PROFIBUS_MPI_FUNCTIONLIST_H */
